var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    (function (Controls) {
        (function (Charting) {
            (function (ChartViewType) {
                ChartViewType._map = [];
                ChartViewType._map[0] = "Scale";
                ChartViewType.Scale = 0;
                ChartViewType._map[1] = "Expand";
                ChartViewType.Expand = 1;
                ChartViewType._map[2] = "Roll";
                ChartViewType.Roll = 2;
                ChartViewType._map[3] = "Fixed";
                ChartViewType.Fixed = 3;
            })(Charting.ChartViewType || (Charting.ChartViewType = {}));
            var ChartViewType = Charting.ChartViewType;
            (function (SeriesRenderType) {
                SeriesRenderType._map = [];
                SeriesRenderType.Points = 1;
                SeriesRenderType.Line = 2;
                SeriesRenderType.PointsAndLine = SeriesRenderType.Points | SeriesRenderType.Line;
                SeriesRenderType.VerticalLines = 4;
                SeriesRenderType.Triangles = 8;
            })(Charting.SeriesRenderType || (Charting.SeriesRenderType = {}));
            var SeriesRenderType = Charting.SeriesRenderType;
            (function (SeriesOrderType) {
                SeriesOrderType._map = [];
                SeriesOrderType._map[0] = "Sort";
                SeriesOrderType.Sort = 0;
                SeriesOrderType._map[1] = "Remove";
                SeriesOrderType.Remove = 1;
            })(Charting.SeriesOrderType || (Charting.SeriesOrderType = {}));
            var SeriesOrderType = Charting.SeriesOrderType;
            var ChartColorType;
            (function (ChartColorType) {
                ChartColorType._map = [];
                ChartColorType._map[0] = "Background";
                ChartColorType.Background = 0;
                ChartColorType._map[1] = "Foreground";
                ChartColorType.Foreground = 1;
                ChartColorType._map[2] = "Grid";
                ChartColorType.Grid = 2;
                ChartColorType._map[3] = "LegendBackground";
                ChartColorType.LegendBackground = 3;
                ChartColorType._map[4] = "ViewSelection";
                ChartColorType.ViewSelection = 4;
                ChartColorType._map[5] = "ViewSelectionOutside";
                ChartColorType.ViewSelectionOutside = 5;
            })(ChartColorType || (ChartColorType = {}));
            var ChartFontType;
            (function (ChartFontType) {
                ChartFontType._map = [];
                ChartFontType._map[0] = "Foreground";
                ChartFontType.Foreground = 0;
            })(ChartFontType || (ChartFontType = {}));
            var Point2d = (function () {
                function Point2d(x, y) {
                    this.x = x;
                    this.y = y;
                }
                return Point2d;
            })();            
            var Point2dWithData = (function (_super) {
                __extends(Point2dWithData, _super);
                function Point2dWithData(x, y, data) {
                                _super.call(this, x, y);
                    this.data = data;
                }
                return Point2dWithData;
            })(Point2d);            
            var Point2dRendered = (function (_super) {
                __extends(Point2dRendered, _super);
                function Point2dRendered(x, y, isInView, seriesIndex) {
                                _super.call(this, x, y);
                    this.isInView = isInView;
                    this.seriesIndex = seriesIndex;
                }
                return Point2dRendered;
            })(Point2d);            
            var Padding = (function () {
                function Padding(left, top, right, bottom) {
                    this.left = left;
                    this.top = top;
                    this.right = right;
                    this.bottom = bottom;
                }
                return Padding;
            })();            
            var Rect = (function (_super) {
                __extends(Rect, _super);
                function Rect(left, top, right, bottom) {
                                _super.call(this, left, top, right, bottom);
                    if(this.left > this.right || this.top > this.bottom) {
                        throw "Invalid rectange size";
                    }
                }
                Object.defineProperty(Rect.prototype, "width", {
                    get: function () {
                        return this.right - this.left;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(Rect.prototype, "height", {
                    get: function () {
                        return this.bottom - this.top;
                    },
                    enumerable: true,
                    configurable: true
                });
                return Rect;
            })(Padding);            
            var MinMax = (function () {
                function MinMax(min, max) {
                    this.min = min;
                    this.max = max;
                }
                return MinMax;
            })();            
            var ChartSeries = (function () {
                function ChartSeries(index, legendText, seriesRenderType) {
                    this._lineColorString = "#FF0000";
                    this._lineFillColorString = "#FF0000";
                    this._pointColorString = "#FF0000";
                    this._pointStrokeColorString = "#FF0000";
                    this.index = index;
                    this.legendText = legendText;
                    this.seriesRenderType = seriesRenderType;
                    this.data = [];
                    switch(index) {
                        case 0: {
                            this._lineColorString = "rgb(180, 180, 255)";
                            this._lineFillColorString = "rgba(200, 200, 255, 0.3)";
                            this._pointColorString = "rgb(0, 0, 255)";
                            this._pointStrokeColorString = "rgb(0, 0, 0)";
                            break;

                        }
                        case 1: {
                            this._lineColorString = "rgb(255, 180, 180)";
                            this._lineFillColorString = "rgba(255, 200, 200, 0.3)";
                            this._pointColorString = "rgb(255, 0, 0)";
                            this._pointStrokeColorString = "rgb(0, 0, 0)";
                            break;

                        }
                        case 2: {
                            this._lineColorString = "rgb(180, 200, 100)";
                            this._lineFillColorString = "rgba(200, 255, 200, 0.3)";
                            this._pointColorString = "rgb(0, 200, 0)";
                            this._pointStrokeColorString = "rgb(0, 0, 0)";
                            break;

                        }
                        case 3: {
                            this._lineColorString = "rgb(180, 255, 255)";
                            this._lineFillColorString = "rgba(200, 255, 255, 0.3)";
                            this._pointColorString = "rgb(0, 255, 255)";
                            this._pointStrokeColorString = "rgb(0, 0, 0)";
                            break;

                        }
                        case 4: {
                            this._lineColorString = "rgb(255, 255, 180)";
                            this._lineFillColorString = "rgba(255, 255, 200, 0.3)";
                            this._pointColorString = "rgb(255, 255, 0)";
                            this._pointStrokeColorString = "rgb(0, 0, 0)";
                            break;

                        }
                        default: {
                            break;

                        }
                    }
                }
                Object.defineProperty(ChartSeries.prototype, "lineColor", {
                    get: function () {
                        return this._lineColorString;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ChartSeries.prototype, "lineFillColor", {
                    get: function () {
                        return this._lineFillColorString;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ChartSeries.prototype, "pointColor", {
                    get: function () {
                        return this._pointColorString;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ChartSeries.prototype, "pointStrokeColor", {
                    get: function () {
                        return this._pointStrokeColorString;
                    },
                    enumerable: true,
                    configurable: true
                });
                return ChartSeries;
            })();            
            var CanvasChartControl = (function (_super) {
                __extends(CanvasChartControl, _super);
                function CanvasChartControl(containerId) {
                                _super.call(this, "CanvasChartTemplate");
                    this._chartInitialStartSet = false;
                    this._chartAxisPadding = new Padding(50, 40, 5, 5);
                    this._chartAxisCount = 5;
                    this._chartAxisIncreaseRatio = 1.5;
                    this._chartDrawFill = true;
                    this._chartOverviewPadding = 4;
                    this._chartViewOverview = false;
                    this._chartViewX = 0;
                    this._chartViewWidth = 60;
                    this._chartViewType = ChartViewType.Roll;
                    this._gridX = new MinMax(0, 0);
                    this._gridY = new MinMax(0, 0);
                    this._gridRange = new Point2d(0, 0);
                    this._triangleSize = 7;
                    this._containerId = containerId;
                    this._series = [];
                    this._container = document.getElementById(this._containerId);
                    if(this._container !== null) {
                        this._container.appendChild(this.rootElement);
                        this._canvas = this.findElement("mainCanvas");
                        this._context = this._canvas.getContext("2d");
                        if(!this._container.runtimeStyle.position || this._container.runtimeStyle.position === "static") {
                            this._container.style.position = "relative";
                        }
                        window.addEventListener("resize", this.onResize.bind(this));
                        this.onResize(null);
                    } else {
                        throw "An element with id " + this._containerId + " could not be found";
                    }
                }
                CanvasChartControl.prototype.onResize = function (event) {
                    if(this._container.clientWidth > 0 && this._container.clientHeight > 0) {
                        this._canvas.width = this._container.clientWidth;
                        this._canvas.height = this._container.clientHeight;
                        this._chartWidth = this._canvas.width - this._chartAxisPadding.right;
                        this._chartHeight = this._canvas.height - this._chartAxisPadding.bottom;
                        this.drawChart();
                    }
                };
                CanvasChartControl.prototype.getColor = function (colorId) {
                    switch(colorId) {
                        case ChartColorType.Background: {
                            return "rgb(255, 255, 255)";

                        }
                        case ChartColorType.Foreground: {
                            return "rgb(0, 0, 0)";

                        }
                        case ChartColorType.Grid: {
                            return "rgb(200, 200, 200)";

                        }
                        case ChartColorType.LegendBackground: {
                            return "rgba(250, 250, 250, 0.75)";

                        }
                        case ChartColorType.ViewSelection: {
                            return "rgb(120, 120, 120)";

                        }
                        case ChartColorType.ViewSelectionOutside: {
                            return "rgba(255, 255, 255, 0.6)";

                        }
                    }
                    return "rgb(255, 0, 0)";
                };
                CanvasChartControl.prototype.getFontString = function (fontId) {
                    switch(fontId) {
                        case ChartFontType.Foreground: {
                            return "7.5pt Segoe UI";

                        }
                    }
                    return "7.5pt Segoe UI";
                };
                CanvasChartControl.prototype.getYCoord = function (y, top, height) {
                    return top + ((this._gridY.max - y) / this._gridRange.y) * height;
                };
                CanvasChartControl.prototype.drawXAxesValue = function (value, offsetY) {
                    this._context.save();
                    this._context.fillStyle = this.getColor(ChartColorType.Foreground);
                    this._context.font = this.getFontString(ChartFontType.Foreground);
                    this._context.fillText("" + value.toFixed(2), this._chartAxisPadding.left - 5, this._chartAxisPadding.top + offsetY + 1.5);
                    this._context.restore();
                };
                CanvasChartControl.prototype.drawChartBackground = function () {
                    this._context.fillStyle = this.getColor(ChartColorType.Background);
                    this._context.fillRect(0, 0, this._canvas.width, this._canvas.height);
                };
                CanvasChartControl.prototype.drawChartAxes = function (chartRect) {
                    this._context.fillStyle = this.getColor(ChartColorType.Grid);
                    this._context.strokeStyle = this.getColor(ChartColorType.Grid);
                    this._context.textAlign = "right";
                    var step = (this._gridRange.y / this._chartAxisCount);
                    this.drawXAxesValue(this._gridY.max, 0);
                    for(var i = 1; i < this._chartAxisCount; i++) {
                        var y = ((step * i) / this._gridRange.y) * chartRect.height;
                        var lineY = chartRect.top + Math.floor(y) + 0.5;
                        this._context.beginPath();
                        this._context.moveTo(chartRect.left, lineY);
                        this._context.lineTo(chartRect.left + chartRect.width, lineY);
                        this._context.stroke();
                        this.drawXAxesValue(this._gridY.max - (step * i), y);
                    }
                    this.drawXAxesValue(this._gridY.min, chartRect.height);
                };
                CanvasChartControl.prototype.drawChartBorder = function (chartRect) {
                    this._context.fillStyle = "transparent";
                    this._context.strokeStyle = this.getColor(ChartColorType.Foreground);
                    this._context.strokeRect(chartRect.left - 0.5, chartRect.top - 0.5, chartRect.width, chartRect.height);
                };
                CanvasChartControl.prototype.drawChartLegend = function (chartRect) {
                    if(!this._legendDiv) {
                        this._legendDiv = document.createElement("div");
                        this._legendDiv.className = "chartLegend";
                        this._legendDiv.style.position = "absolute";
                        this._legendDiv.style.right = "20px";
                        this._legendDiv.style.bottom = (this._canvas.height - chartRect.bottom + 10) + "px";
                        this._legendDiv.style.backgroundColor = this.getColor(ChartColorType.LegendBackground);
                        this._legendDiv.style.color = this.getColor(ChartColorType.Foreground);
                        this._legendDiv.style.padding = "2px 5px 2px 5px";
                        this._legendDiv.style.font = this.getFontString(ChartFontType.Foreground);
                        this._legendDiv.style.borderRadius = "3px";
                        if(this._container !== null) {
                            this._container.appendChild(this._legendDiv);
                        }
                    }
                    if(this._legendDiv.children.length !== this._series.length) {
                        for(var i = 0; i < this._series.length; i++) {
                            var seriesDiv = document.createElement("div");
                            seriesDiv.className = "chartLegendSeries";
                            var colorSpan = document.createElement("span");
                            colorSpan.style.display = "inline-block";
                            colorSpan.style.width = "16px";
                            colorSpan.style.height = "10px";
                            colorSpan.style.margin = "0 4px 2px 0";
                            colorSpan.style.verticalAlign = "middle";
                            colorSpan.style.border = "solid " + this._series[i].lineColor + " 1px";
                            if(this._series[i].seriesRenderType & SeriesRenderType.Line) {
                                colorSpan.style.backgroundColor = this._series[i].lineFillColor;
                            }
                            var innerColorSpan = document.createElement("span");
                            innerColorSpan.style.display = "inline-block";
                            innerColorSpan.style.width = "12px";
                            innerColorSpan.style.height = "8px";
                            innerColorSpan.style.margin = "0 0 10px 1px";
                            innerColorSpan.style.verticalAlign = "middle";
                            innerColorSpan.style.backgroundColor = this._series[i].pointColor;
                            colorSpan.appendChild(innerColorSpan);
                            seriesDiv.appendChild(colorSpan);
                            var textSpan = document.createElement("span");
                            textSpan.innerText = this._series[i].legendText;
                            seriesDiv.appendChild(textSpan);
                            this._legendDiv.appendChild(seriesDiv);
                        }
                    }
                };
                CanvasChartControl.prototype.drawChartType = function (chartViewType, chartRect, isOverview) {
                    var renderedPoints = new Array();
                    for(var seriesIndex = 0; seriesIndex < this._series.length; seriesIndex++) {
                        var series = this._series[seriesIndex];
                        var seriesPoints = series.data;
                        if(seriesPoints.length > 0) {
                            var startIndex = 0;
                            var endIndex = seriesPoints.length - 1;
                            var startX = 0;
                            var rangeX = 0;
                            switch(chartViewType) {
                                case ChartViewType.Scale: {
                                    startX = this._gridX.min;
                                    rangeX = this._gridRange.x;
                                    break;

                                }
                                case ChartViewType.Expand: {
                                    startX = this._gridX.min;
                                    rangeX = Math.max(this._gridRange.x, this._chartViewWidth);
                                    break;

                                }
                                case ChartViewType.Fixed: {
                                    startX = this._chartViewX;
                                    rangeX = this._chartViewWidth;
                                    break;

                                }
                                case ChartViewType.Roll: {
                                    this._chartViewX = Math.max(this._gridX.max - this._chartViewWidth, this._gridX.min);
                                    startX = this._chartViewX;
                                    rangeX = this._chartViewWidth;
                                    break;

                                }
                            }
                            var endX = startX + rangeX;
                            var scaleX = chartRect.width / rangeX;
                            var x = 0;
                            var y = 0;
                            var startPoint = seriesPoints[startIndex];
                            var hasMovedToStart = false;
                            this._context.save();
                            this._context.beginPath();
                            this._context.rect(chartRect.left, chartRect.top, chartRect.width, chartRect.height);
                            this._context.clip();
                            this._context.fillStyle = series.lineFillColor;
                            this._context.strokeStyle = series.lineColor;
                            this._context.beginPath();
                            for(var i = startIndex; i <= endIndex; i++) {
                                var point = seriesPoints[i];
                                var pointInView = (point.x >= startX && point.x <= endX);
                                var requiresDrawing = pointInView;
                                if(!requiresDrawing) {
                                    if((point.x < startX && i < endIndex && seriesPoints[i + 1].x > startX) || (point.x > endX && i > 0 && seriesPoints[i - 1].x < endX)) {
                                        requiresDrawing = true;
                                    }
                                }
                                if(requiresDrawing) {
                                    x = chartRect.left + (point.x - startX) * scaleX;
                                    y = this.getYCoord(point.y, chartRect.top, chartRect.height);
                                    if(!hasMovedToStart) {
                                        this._context.moveTo(x, this.getYCoord(0, chartRect.top, chartRect.height));
                                        hasMovedToStart = true;
                                    }
                                    if(series.seriesRenderType & SeriesRenderType.Line) {
                                        this._context.lineTo(x, y);
                                    }
                                    renderedPoints.push({
                                        x: x,
                                        y: y,
                                        isInView: pointInView,
                                        seriesIndex: seriesIndex
                                    });
                                }
                            }
                            if(series.seriesRenderType & SeriesRenderType.Line) {
                                if(this._chartDrawFill) {
                                    var y = this.getYCoord(0, chartRect.top, chartRect.height);
                                    this._context.lineTo(x, y);
                                    this._context.closePath();
                                    this._context.fill();
                                } else {
                                    this._context.stroke();
                                }
                                if(this._chartDrawFill) {
                                    this._context.lineWidth = (chartRect.height < 100 ? 1 : 2);
                                    this._context.strokeStyle = series.lineColor;
                                    this._context.beginPath();
                                    for(var i = 0; i < renderedPoints.length; i++) {
                                        var rp = renderedPoints[i];
                                        if(i === 0) {
                                            this._context.moveTo(rp.x, Math.round(rp.y) - 0.5);
                                        }
                                        this._context.lineTo(rp.x, Math.round(rp.y) - 0.5);
                                    }
                                    this._context.stroke();
                                }
                            }
                            this._context.restore();
                        }
                    }
                    this.drawChartBorder(chartRect);
                    var overviewStartX = chartRect.left + (this._chartViewX - this._gridX.min) * scaleX;
                    var overviewEndX = overviewStartX + Math.min(this._chartViewWidth * scaleX, chartRect.width);
                    var seriesIndexForColor = -1;
                    for(var i = 0; i < renderedPoints.length; i++) {
                        if(renderedPoints[i].isInView) {
                            var si = renderedPoints[i].seriesIndex;
                            if(seriesIndexForColor !== si) {
                                this._context.fillStyle = this._series[si].pointColor;
                                this._context.strokeStyle = this._series[si].pointStrokeColor;
                                seriesIndexForColor = si;
                            }
                            if(this._series[si].seriesRenderType & SeriesRenderType.Points) {
                                this._context.beginPath();
                                this._context.arc(renderedPoints[i].x - 0.5, renderedPoints[i].y - 0.5, 3, 0, Math.PI * 2);
                                this._context.fill();
                            }
                            if(this._series[si].seriesRenderType & SeriesRenderType.VerticalLines) {
                                this._context.beginPath();
                                this._context.rect(Math.round(renderedPoints[i].x), chartRect.top, 1, chartRect.height);
                                this._context.fill();
                            }
                            if(this._series[si].seriesRenderType & SeriesRenderType.Triangles) {
                                this._context.beginPath();
                                this._context.moveTo(renderedPoints[i].x, chartRect.bottom - 2 * this._triangleSize);
                                this._context.lineTo(renderedPoints[i].x - this._triangleSize, chartRect.bottom);
                                this._context.lineTo(renderedPoints[i].x + this._triangleSize, chartRect.bottom);
                                this._context.lineTo(renderedPoints[i].x, chartRect.bottom - 2 * this._triangleSize);
                                this._context.closePath();
                                this._context.fill();
                            }
                        }
                    }
                };
                CanvasChartControl.prototype.drawChartViewSelection = function (chartRect) {
                    var padding = this._chartOverviewPadding;
                    var doublePadding = padding * 2;
                    var scaleX = (chartRect.width / this._gridRange.x);
                    var x = (this._chartViewX - this._gridX.min) * scaleX;
                    var y = chartRect.top - padding;
                    var w = Math.min(this._chartViewWidth * scaleX, chartRect.width);
                    var h = chartRect.height + doublePadding;
                    this._context.fillStyle = this.getColor(ChartColorType.ViewSelectionOutside);
                    this._context.fillRect(chartRect.left - padding, y, Math.max(x, 0), h);
                    this._context.fillRect(chartRect.left + x + w + padding, y, Math.max(chartRect.width - (x + w), 0), h);
                    var snappedX = Math.floor(chartRect.left + x - padding) - 0.5;
                    var snappedY = Math.floor(chartRect.top - padding) - 0.5;
                    var snappedW = Math.ceil(w + doublePadding);
                    var snappedH = Math.ceil(chartRect.height + doublePadding);
                    this._context.save();
                    this._context.strokeStyle = this.getColor(ChartColorType.ViewSelection);
                    this._context.lineWidth = 1;
                    this._context.strokeRect(snappedX, snappedY, snappedW, snappedH);
                    this._context.restore();
                };
                CanvasChartControl.prototype.drawChart = function () {
                    if(this._chartViewType === ChartViewType.Scale || this._chartViewType === ChartViewType.Expand) {
                        this._chartViewX = this._gridX.min;
                        this._chartViewWidth = Math.max(this._gridRange.x, this._chartViewWidth);
                    }
                    this.drawChartBackground();
                    var chartRect = new Rect(this._chartAxisPadding.left, this._chartAxisPadding.top, this._chartWidth, this._chartHeight - (this._chartViewOverview ? 40 : 0));
                    this.drawChartAxes(chartRect);
                    this.drawChartType(this._chartViewType, chartRect, false);
                    this.drawChartLegend(chartRect);
                    if(this._chartViewOverview) {
                        chartRect.top += chartRect.height + 10;
                        chartRect.bottom = chartRect.top + 30;
                        this.drawChartType(ChartViewType.Expand, chartRect, true);
                        this.drawChartViewSelection(chartRect);
                    }
                };
                CanvasChartControl.prototype.calculateRange = function (point) {
                    if(this._gridX.max < point.x) {
                        this._gridX.max = point.x;
                    }
                    if(this._gridX.min > point.x) {
                        this._gridX.min = point.x;
                    }
                    if(this._gridY.min > point.y) {
                        this._gridY.min = Math.floor((point.y * this._chartAxisIncreaseRatio) / this._chartAxisCount) * this._chartAxisCount;
                    }
                    if(this._gridY.max < point.y) {
                        this._gridY.max = Math.ceil((point.y * this._chartAxisIncreaseRatio) / this._chartAxisCount) * this._chartAxisCount;
                    }
                    this._gridRange.x = this._gridX.max - this._gridX.min;
                    this._gridRange.y = this._gridY.max - this._gridY.min;
                };
                CanvasChartControl.prototype.setViewType = function (viewType, viewStartX, viewWidth, viewHeight) {
                    if(viewStartX < this._gridX.min) {
                        viewStartX = this._gridX.min;
                    }
                    this._chartViewType = viewType;
                    this._chartViewX = viewStartX;
                    this._chartViewWidth = viewWidth;
                    if(typeof viewHeight === "number") {
                        this._gridY.max = viewHeight;
                        this._gridRange.y = viewHeight;
                    }
                    this.drawChart();
                };
                CanvasChartControl.prototype.addSeries = function (legendText, seriesRenderType) {
                    var newSeries = new ChartSeries(this._series.length, legendText, seriesRenderType);
                    this._series.push(newSeries);
                    var filledLines = 0;
                    for(var i = 0; i < this._series.length; i++) {
                        if(this._series[i].seriesRenderType & SeriesRenderType.Line) {
                            filledLines++;
                            if(filledLines >= 2) {
                                this._chartDrawFill = false;
                                break;
                            }
                        }
                    }
                    return this._series.length - 1;
                };
                CanvasChartControl.prototype.addPointToSeries = function (seriesIndex, x, y, tooltip, orderType, skipRender) {
                    if (typeof orderType === "undefined") { orderType = SeriesOrderType.Sort; }
                    if(seriesIndex >= 0 && seriesIndex < this._series.length) {
                        var newPoint = new Point2dWithData(x, y, tooltip);
                        var seriesData = this._series[seriesIndex].data;
                        seriesData.push(newPoint);
                        if(newPoint.x < this._gridX.max) {
                            switch(orderType) {
                                case SeriesOrderType.Remove: {
                                    for(var deleteIndex = seriesData.length - 2; deleteIndex >= 0; deleteIndex--) {
                                        if(seriesData[deleteIndex].x < x) {
                                            break;
                                        }
                                    }
                                    deleteIndex++;
                                    seriesData.splice(deleteIndex, seriesData.length - deleteIndex - 1);
                                    this._gridX.max = newPoint.x;
                                    break;

                                }
                                case SeriesOrderType.Sort:
                                default: {
                                    seriesData.sort(function (a, b) {
                                        return a.x - b.x;
                                    });
                                    break;

                                }
                            }
                        }
                        if(!this._chartInitialStartSet) {
                            this._chartInitialStartSet = true;
                            this._gridX.min = newPoint.x;
                            this._chartViewX = newPoint.x;
                        }
                        this.calculateRange(newPoint);
                        if(!skipRender) {
                            this.drawChart();
                        }
                    }
                };
                return CanvasChartControl;
            })(Common.Controls.TemplateControl);
            Charting.CanvasChartControl = CanvasChartControl;            
        })(Controls.Charting || (Controls.Charting = {}));
        var Charting = Controls.Charting;
    })(MemoryAnalyzer.Controls || (MemoryAnalyzer.Controls = {}));
    var Controls = MemoryAnalyzer.Controls;
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=canvasChartControl.js.map

// SIG // Begin signature block
// SIG // MIIaswYJKoZIhvcNAQcCoIIapDCCGqACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFC8GuZEtqbDk
// SIG // BKvp3ndXTNM44ab4oIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AAArOTJIwbLJSPMAAAAAACswDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTEyMDkwNDIx
// SIG // MTIzNFoXDTEzMTIwNDIxMTIzNFowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKa2MA4DZa5QWoZrhZ9IoR7JwO5eSQeF4HCWfL65
// SIG // X2JfBibTizm7GCKlLpKt2EuIOhqvm4OuyF45jMIyexZ4
// SIG // 7Tc4OvFi+2iCAmjs67tAirH+oSw2YmBwOWBiDvvGGDhv
// SIG // sJLWQA2Apg14izZrhoomFxj/sOtNurspE+ZcSI5wRjYm
// SIG // /jQ1qzTh99rYXOqZfTG3TR9X63zWlQ1mDB4OMhc+LNWA
// SIG // oc7r95iRAtzBX/04gPg5f11kyjdcO1FbXYVfzh4c+zS+
// SIG // X+UoVXBUnLjsfABVRlsomChWTOHxugkZloFIKjDI9zMg
// SIG // bOdpw7PUw07PMB431JhS1KkjRbKuXEFJT7RiaJMCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBSlGDNTP5VgoUMW747G
// SIG // r9Irup5Y0DAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQB+zLB75S++
// SIG // 51a1z3PbqlLRFjnGtM361/4eZbXnSPObRogFZmomhl7+
// SIG // h1jcxmOOOID0CEZ8K3OxDr9BqsvHqpSkN/BkOeHF1fnO
// SIG // B86r5CXwaa7URuL+ZjI815fFMiH67holoF4MQiwRMzqC
// SIG // g/3tHbO+zpGkkSVxuatysJ6v5M8AYolwqbhKUIzuLyJk
// SIG // pajmTWuVLBx57KejMdqQYJCkbv6TAg0/LCQNxmomgVGD
// SIG // ShC7dWNEqmkIxgPr4s8L7VY67O9ypwoM9ADTIrivInKz
// SIG // 58ScCyiggMrj4dc5ZjDnRhcY5/qC+lkLeryoDf4c/wOL
// SIG // Y7JNEgIjTy2zhYQ74qFH6M8VMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAALARrwqL0Duf3QABAAAAsDANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xMzAx
// SIG // MjQyMjMzMzlaFw0xNDA0MjQyMjMzMzlaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDor1yiIA34
// SIG // KHy8BXt/re7rdqwoUz8620B9s44z5lc/pVEVNFSlz7SL
// SIG // qT+oN+EtUO01Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Un
// SIG // m/P4LZ5BNisLQPu+O7q5XHWTFlJLyjPFN7Dz636o9UEV
// SIG // XAhlHSE38Cy6IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpO
// SIG // oPXJCiHiquMBNkf9L4JqgQP1qTXclFed+0vUDoLbOI8S
// SIG // /uPWenSIZOFixCUuKq6dGB8OHrbCryS0DlC83hyTXEmm
// SIG // ebW22875cHsoAYS4KinPv6kFBeHgD3FN/a1cI4Mp68fF
// SIG // SsjoJ4TTfsZDC5UABbFPZXHFAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGm
// SIG // WjNN2pgHgP+EHr6H+XIyQfIwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRm
// SIG // YWYwYjcxLWFkMzctNGFhMy1hNjcxLTc2YmMwNTIzNDRh
// SIG // ZDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEAMdduKhJXM4HVncbr+TrURE0Inu5e32pbt3nPApy8
// SIG // dmiekKGcC8N/oozxTbqVOfsN4OGb9F0kDxuNiBU6fNut
// SIG // zrPJbLo5LEV9JBFUJjANDf9H6gMH5eRmXSx7nR2pEPoc
// SIG // sHTyT2lrnqkkhNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2y
// SIG // RPnwPJNtQtjofOYXoJtoaAko+QKX7xEDumdSrcHps3Om
// SIG // 0mPNSuI+5PNO/f+h4LsCEztdIN5VP6OukEAxOHUoXgSp
// SIG // Rm3m9Xp5QL0fzehF1a7iXT71dcfmZmNgzNWahIeNJDD3
// SIG // 7zTQYx2xQmdKDku/Og7vtpU6pzjkJZIIpohmgjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggSdMIIEmQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAALARrwqL0Duf3QAB
// SIG // AAAAsDAJBgUrDgMCGgUAoIG2MBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBSx46FQkdHG
// SIG // UsCwZdBR2AD2qAjygDBWBgorBgEEAYI3AgEMMUgwRqAs
// SIG // gCoAYwBhAG4AdgBhAHMAQwBoAGEAcgB0AEMAbwBuAHQA
// SIG // cgBvAGwALgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5j
// SIG // b20wDQYJKoZIhvcNAQEBBQAEggEATisL1+Od2HIl4YEn
// SIG // Zax88z4sUYqu/DxCEyDrfzI+boUFAv7DW5asvL5Ir5IR
// SIG // 7rklKueAYkxC8xpsGKF98hM8tp7WAYIPazXvc9A35640
// SIG // rpeQiAUO4wFRSPOlwMMHPEyrH3Eo9Yit/ebJQ5tBktZS
// SIG // ZnJJ1lMbkKYpu3I+FHIVfCNLKsJ87kw3w8pZqLHUj6Sf
// SIG // dDRvrMLxl83ibjVO5SVtfihC1VqzAbQNDJGodAhzwLHS
// SIG // vi+xOKkJjFAIVOfQ2tJfgRuJLqd7aIfGBMZnPgoERLlg
// SIG // xjZBdW0RkSt3VQ2/EjKygsG653/RNEP1E2en4yg59QgJ
// SIG // VGR+LL33wbky/i2u46GCAigwggIkBgkqhkiG9w0BCQYx
// SIG // ggIVMIICEQIBATCBjjB3MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0ECEzMAAAArOTJIwbLJSPMAAAAAACswCQYFKw4DAhoF
// SIG // AKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJ
// SIG // KoZIhvcNAQkFMQ8XDTEzMDMxNTA2MzM1OVowIwYJKoZI
// SIG // hvcNAQkEMRYEFAofcG0iPkBJ48DEendn7nZNvxwAMA0G
// SIG // CSqGSIb3DQEBBQUABIIBAEWdsXD0MWXY6waPdvM4IDmr
// SIG // nWR+vTNY1+5nCwCOTdInkeIx+48ZQ/U6mvpOS+XT/ZF7
// SIG // PTla0BlMBvQ/JbnnirSVky5mj/oIeKbdIreYwx32YnMM
// SIG // oZCWIg7D8D5dvFAGzgD7P9rfZo+4ahDUmVKsmYSsik9R
// SIG // S/e/7SPY8CO7LOBdI2d7Fj/sm4PcI7mgWo0F8mmAsPIc
// SIG // yHn3tiqI5fqGSXR6X/Fl1wkpuMXCR2JcXpxYs9LobxYN
// SIG // C10uA8P1kR9b9RZk9ki24/OgIMD88ZY/+iXDTPL3/SSL
// SIG // NDwr0o7Uh7IoKDLoHaMLnhghJVLr1s0BALa86SmcLxh4
// SIG // m1KGZtlW9os=
// SIG // End signature block
